<?php
require_once __DIR__ . '/../config.php';

setApiHeaders();

// Get the request URI and method
$requestUri = $_SERVER['REQUEST_URI'];
$method = $_SERVER['REQUEST_METHOD'];

// Remove base path and query string
$path = parse_url($requestUri, PHP_URL_PATH);
// Handle both /landsearch/api and /api paths
$path = preg_replace('#^/landsearch/api#', '', $path);
$path = preg_replace('#^/api#', '', $path);
$path = trim($path, '/');

// Route the request
$conn = getDbConnection();

// Initialize tables
ensureSearchHistoryTable($conn);
ensureProfilePictureColumn($conn);

// Parse path segments
$segments = explode('/', $path);
$resource = $segments[0] ?? '';
$id = $segments[1] ?? null;
$subResource = $segments[2] ?? null;

switch ($resource) {
    case 'login':
        require_once __DIR__ . '/login.php';
        handleLogin($conn);
        break;

    case 'states':
        require_once __DIR__ . '/locations.php';
        handleStates($conn);
        break;

    case 'provinces':
        require_once __DIR__ . '/locations.php';
        handleProvinces($conn, $id);
        break;

    case 'cities':
        require_once __DIR__ . '/locations.php';
        handleCities($conn, $id);
        break;

    case 'blocks':
        require_once __DIR__ . '/locations.php';
        handleBlocks($conn, $id);
        break;

    case 'lands':
        require_once __DIR__ . '/lands.php';
        if ($id === 'search') {
            handleLandSearch($conn);
        } else {
            handleGetLand($conn, $id);
        }
        break;

    case 'users':
        require_once __DIR__ . '/users.php';
        handleUsers($conn, $method, $id);
        break;

    case 'groups':
        require_once __DIR__ . '/users.php';
        handleGroups($conn);
        break;

    case 'search-history':
        require_once __DIR__ . '/search-history.php';
        handleSearchHistory($conn, $method, $id, $subResource);
        break;

    case 'profile':
        require_once __DIR__ . '/profile.php';
        handleProfile($conn, $method, $id);
        break;

    case 'setup':
        if ($id === 'testdata') {
            require_once __DIR__ . '/setup.php';
            handleSetupTestData($conn);
        } else {
            sendResponse(['error' => 'Not found'], 404);
        }
        break;

    default:
        sendResponse(['error' => 'Endpoint not found', 'path' => $path], 404);
}

$conn->close();
?>
