<?php
function handleLandSearch($conn) {
    $province = $_GET['province'] ?? null;
    $city = $_GET['city'] ?? null;
    $block = $_GET['block'] ?? null;
    $landId = $_GET['landId'] ?? null;

    $conditions = [];
    $params = [];
    $types = '';

    if ($landId) {
        // Search by land ID
        $conditions[] = 'land_id = ?';
        $params[] = $landId;
        $types .= 's';
    } else {
        // Search by location
        if ($province) {
            $conditions[] = 'P_CODE = ?';
            $params[] = $province;
            $types .= 's';
        }
        if ($city) {
            $conditions[] = 'no_city = ?';
            $params[] = $city;
            $types .= 's';
        }
        if ($block) {
            $conditions[] = 'block_no = ?';
            $params[] = $block;
            $types .= 's';
        }
    }

    if (empty($conditions)) {
        sendResponse(['error' => 'At least one search parameter is required'], 400);
    }

    $sql = 'SELECT * FROM land_data WHERE ' . implode(' AND ', $conditions) . ' LIMIT 1000';
    $stmt = $conn->prepare($sql);

    if (!empty($params)) {
        $stmt->bind_param($types, ...$params);
    }

    $stmt->execute();
    $result = $stmt->get_result();

    $lands = [];
    while ($row = $result->fetch_assoc()) {
        $lands[] = $row;
    }
    $stmt->close();
    sendResponse($lands);
}

function handleGetLand($conn, $landId) {
    if (!$landId) {
        sendResponse(['error' => 'Land ID required'], 400);
    }

    $stmt = $conn->prepare('SELECT * FROM land_data WHERE land_id = ?');
    $stmt->bind_param('s', $landId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        sendResponse(['error' => 'Land not found'], 404);
    }

    $land = $result->fetch_assoc();
    $stmt->close();
    sendResponse($land);
}
?>
