<?php
function handleStates($conn) {
    $result = $conn->query('SELECT states_no as id, states_name as name FROM land_States ORDER BY states_name');
    if (!$result) {
        sendResponse(['error' => 'Database error: ' . $conn->error], 500);
    }
    $states = [];
    while ($row = $result->fetch_assoc()) {
        $states[] = $row;
    }
    sendResponse($states);
}

function handleProvinces($conn, $stateId) {
    if (!$stateId) {
        sendResponse(['error' => 'State ID required'], 400);
    }

    $stmt = $conn->prepare('SELECT P_CODE as id, PROVINCE as name FROM land_PROVINCE WHERE St_no = ? ORDER BY PROVINCE');
    if (!$stmt) {
        sendResponse(['error' => 'Database error: ' . $conn->error], 500);
    }
    $stmt->bind_param('s', $stateId);
    $stmt->execute();
    $result = $stmt->get_result();

    $provinces = [];
    while ($row = $result->fetch_assoc()) {
        $provinces[] = $row;
    }
    $stmt->close();
    sendResponse($provinces);
}

function handleCities($conn, $provinceId) {
    if (!$provinceId) {
        sendResponse(['error' => 'Province ID required'], 400);
    }

    $stmt = $conn->prepare('SELECT no_city as id, MAX(city) as name FROM land_Cities WHERE P_CODE = ? AND city IS NOT NULL AND city != \'\' GROUP BY no_city ORDER BY name');
    if (!$stmt) {
        sendResponse(['error' => 'Database error: ' . $conn->error], 500);
    }
    $stmt->bind_param('s', $provinceId);
    $stmt->execute();
    $result = $stmt->get_result();

    $cities = [];
    while ($row = $result->fetch_assoc()) {
        $cities[] = $row;
    }
    $stmt->close();
    sendResponse($cities);
}

function handleBlocks($conn, $cityId) {
    if (!$cityId) {
        sendResponse(['error' => 'City ID required'], 400);
    }

    $stmt = $conn->prepare('SELECT b_no as id, b_name as name FROM land_Block WHERE no_city = ? ORDER BY CAST(b_no AS UNSIGNED)');
    if (!$stmt) {
        sendResponse(['error' => 'Database error: ' . $conn->error], 500);
    }
    $stmt->bind_param('s', $cityId);
    $stmt->execute();
    $result = $stmt->get_result();

    $blocks = [];
    while ($row = $result->fetch_assoc()) {
        $blocks[] = $row;
    }
    $stmt->close();
    sendResponse($blocks);
}
?>
