<?php
function handleLogin($conn) {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        sendResponse(['error' => 'Method not allowed'], 405);
    }

    $data = getJsonInput();
    $username = $data['username'] ?? '';
    $password = $data['password'] ?? '';

    if (empty($username) || empty($password)) {
        sendResponse(['error' => 'Username and password are required'], 400);
    }

    $sql = 'SELECT user_id, user_n, group_id, Name_of_user, profile_picture FROM land_pass_user WHERE user_n = ? AND pass_w = ? AND active = 1';

    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        sendResponse(['error' => 'Database error: ' . $conn->error], 500);
    }

    $stmt->bind_param('ss', $username, $password);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        sendResponse(['error' => 'Invalid credentials'], 401);
    }

    $user = $result->fetch_assoc();
    $stmt->close();

    sendResponse([
        'success' => true,
        'user' => [
            'id' => $user['user_id'],
            'username' => $user['user_n'],
            'fullName' => $user['Name_of_user'],
            'groupId' => $user['group_id'],
            'profilePicture' => $user['profile_picture'] ?? null
        ]
    ]);
}
?>
