<?php
function handleProfile($conn, $method, $action) {
    switch ($action) {
        case 'password':
            if ($method === 'PUT') {
                changePassword($conn);
            } else {
                sendResponse(['error' => 'Method not allowed'], 405);
            }
            break;
        case 'picture':
            if ($method === 'PUT') {
                updateProfilePicture($conn);
            } else {
                sendResponse(['error' => 'Method not allowed'], 405);
            }
            break;
        default:
            sendResponse(['error' => 'Invalid profile action'], 400);
    }
}

function changePassword($conn) {
    $userId = $_SERVER['HTTP_USER_ID'] ?? null;

    if (!$userId) {
        sendResponse(['error' => 'Unauthorized'], 401);
    }

    $data = getJsonInput();
    $currentPassword = $data['currentPassword'] ?? '';
    $newPassword = $data['newPassword'] ?? '';

    if (empty($currentPassword) || empty($newPassword)) {
        sendResponse(['error' => 'Current and new password are required'], 400);
    }

    // Verify current password
    $stmt = $conn->prepare('SELECT pass_w FROM land_pass_user WHERE user_id = ?');
    $stmt->bind_param('i', $userId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        sendResponse(['error' => 'User not found'], 404);
    }

    $user = $result->fetch_assoc();
    $stmt->close();

    if ($user['pass_w'] !== $currentPassword) {
        sendResponse(['error' => 'Current password is incorrect'], 400);
    }

    // Update password
    $updateStmt = $conn->prepare('UPDATE land_pass_user SET pass_w = ? WHERE user_id = ?');
    $updateStmt->bind_param('si', $newPassword, $userId);

    if ($updateStmt->execute()) {
        $updateStmt->close();
        sendResponse(['success' => true, 'message' => 'Password changed successfully']);
    } else {
        sendResponse(['error' => 'Failed to update password'], 500);
    }
}

function updateProfilePicture($conn) {
    $userId = $_SERVER['HTTP_USER_ID'] ?? null;

    if (!$userId) {
        sendResponse(['error' => 'Unauthorized'], 401);
    }

    $data = getJsonInput();
    $profilePicture = $data['profilePicture'] ?? null;

    $stmt = $conn->prepare('UPDATE land_pass_user SET profile_picture = ? WHERE user_id = ?');
    $stmt->bind_param('si', $profilePicture, $userId);

    if ($stmt->execute()) {
        $stmt->close();
        sendResponse(['success' => true, 'message' => 'Profile picture updated']);
    } else {
        sendResponse(['error' => 'Failed to update profile picture'], 500);
    }
}
?>
