<?php
function handleSetupTestData($conn) {
    checkAdmin($conn);

    // Create test search history entries
    $testEntries = [
        ['user_id' => 1, 'username' => 'admin', 'search_type' => 'location', 'search_params' => '{"province":"1","city":"10"}', 'results_count' => 25],
        ['user_id' => 1, 'username' => 'admin', 'search_type' => 'landId', 'search_params' => '{"landId":"12345"}', 'results_count' => 1],
    ];

    $stmt = $conn->prepare('INSERT INTO search_history (user_id, username, search_type, search_params, results_count) VALUES (?, ?, ?, ?, ?)');

    $inserted = 0;
    foreach ($testEntries as $entry) {
        $stmt->bind_param('isssi', $entry['user_id'], $entry['username'], $entry['search_type'], $entry['search_params'], $entry['results_count']);
        if ($stmt->execute()) {
            $inserted++;
        }
    }
    $stmt->close();

    sendResponse([
        'success' => true,
        'message' => "Inserted $inserted test entries"
    ]);
}
?>
