<?php
// Database configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'digi');
define('DB_PASS', 'SudaVas@123_');
define('DB_NAME', 'all_lands_data');

// Create database connection
function getDbConnection() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

    if ($conn->connect_error) {
        http_response_code(500);
        die(json_encode(['error' => 'Database connection failed: ' . $conn->connect_error]));
    }

    $conn->set_charset('utf8mb4');
    return $conn;
}

// Set headers for API responses
function setApiHeaders() {
    header('Content-Type: application/json; charset=utf-8');
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, user-id');

    // Handle preflight requests
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        http_response_code(200);
        exit();
    }
}

// Get JSON input data
function getJsonInput() {
    $input = file_get_contents('php://input');
    return json_decode($input, true) ?? [];
}

// Send JSON response
function sendResponse($data, $code = 200) {
    http_response_code($code);
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit();
}

// Check if user is admin
function checkAdmin($conn) {
    $userId = $_SERVER['HTTP_USER_ID'] ?? null;

    if (!$userId) {
        sendResponse(['error' => 'Unauthorized'], 401);
    }

    $stmt = $conn->prepare('SELECT user_id FROM land_pass_user WHERE user_id = ? AND group_id = 1 AND active = 1');
    $stmt->bind_param('i', $userId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        sendResponse(['error' => 'Access denied. Admin only.'], 403);
    }

    $stmt->close();
    return true;
}

// Ensure search_history table exists
function ensureSearchHistoryTable($conn) {
    $sql = "CREATE TABLE IF NOT EXISTS search_history (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        username VARCHAR(50),
        search_type VARCHAR(20),
        search_params TEXT,
        results_count INT,
        search_date DATETIME DEFAULT CURRENT_TIMESTAMP,
        INDEX idx_user_id (user_id),
        INDEX idx_search_date (search_date)
    )";
    $conn->query($sql);
}

// Ensure profile_picture column exists
function ensureProfilePictureColumn($conn) {
    $result = $conn->query("SHOW COLUMNS FROM land_pass_user LIKE 'profile_picture'");
    if ($result->num_rows === 0) {
        $conn->query("ALTER TABLE land_pass_user ADD COLUMN profile_picture LONGTEXT");
    }
}
?>
