<?php
// Router for PHP built-in server
$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

// If requesting a real file, serve it
if ($uri !== '/' && file_exists(__DIR__ . $uri)) {
    return false;
}

// Route API requests
if (strpos($uri, '/api/') === 0 || strpos($uri, '/landsearch/api/') === 0) {
    $_SERVER['REQUEST_URI'] = $uri;
    require __DIR__ . '/api/index.php';
    exit;
}

// Serve index.html for other requests
if (file_exists(__DIR__ . '/index.html')) {
    readfile(__DIR__ . '/index.html');
    exit;
}

http_response_code(404);
echo "Not found";
?>
